
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1071.C - Message 1071 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1071 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

// Global data for dr parameters
tUSHORT DRSpeedSigma    = 100;    //standard deviation (1.0m/s)
tUSHORT DRSpeedTimeTag  = 10;     //resolution         (0.1ms)
tUSHORT DRSpeedLatency  = 0;      //latency            (0.0ms)
tUSHORT usDRFLAGWORD    = 3;      //flag
tSHORT  sGyroScale      = 563;    //scale factor       (5.63063063e-3 deg/sec count)
tSHORT  sGyroBias       = 22142;  //bias               (221.424 deg/sec)
tUSHORT usWheelTickRate = 2485;   //rate               (2485 ticks/km)

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1071 message from the ZMsgBuf.
//
void Dec1071(tMSGBUF *ZMsgBuf, tMSG1071 *Msg)
{
   DRSpeedSigma    = Msg->DRSpeedSigma;    
   DRSpeedTimeTag  = Msg->DRSpeedTimeTag;  
   DRSpeedLatency  = Msg->DRSpeedLatency;
   usDRFLAGWORD    = Msg->Reserved[0];
   sGyroScale      = Msg->Reserved[1];
   sGyroBias       = Msg->Reserved[2];
   usWheelTickRate = Msg->Reserved[3];
}                                      

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1071 message in the ZMsgBuf.
//
void Bld1071(tMSGBUF *ZMsgBuf, tMSG1071 *Msg)
{
 
   // build the header in the buffer
   PutShort  (0x81FF                      , ZMsgBuf, 1);     // message preamble
   PutShort  (1071                        , ZMsgBuf, 2);     // message number
   PutShort  (9                           , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                       , ZMsgBuf, 4);     // message ack/nack request

   PutShort  (Msg->SequenceNumber         , ZMsgBuf, 6);    // ND   
   PutUShort (Msg->DRSpeedSigma           , ZMsgBuf, 7);    // E-02 
   PutUShort (Msg->DRSpeedTimeTag         , ZMsgBuf, 8);    // E-02 
   PutUShort (Msg->DRSpeedLatency         , ZMsgBuf, 9);    // E-02 

}                                            


////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1270 message from the ZMsgBuf.
//
void Show1270(tMSG1270 *Msg)
{
; // whatever
}                                                 

end not needed yet */
                                      
                                           
